var melodyTunnel_model


function melodyTunnel_init()
{
	melodyTunnel_model = new Model();

/*	TODO:	generate some cubes around a cylinder, with a fixed size, and a pair of colors per 'cube' (front+top faces should be enough)
 *			fog the colors + change the color of the closest cube when in melody tone is played
 */


	melodyTunnel_model = new Model()


	var	angularWidthCap		= Math.PI/8,
		angularWidthBase	= Math.PI/12,
		distanceCap			= 50,
		distanceBase		= 52;

	melodyTunnel_model.colors =
	[
		'#0ff', '#066',
		'#0cc', '#033',
		'#f00', '#600'
	]

	for( var i=0; i<64; i++ )
	{
		var an = Math.random()*Math.PI*2;

		melodyTunnel_model.vertices.push
		(
			{ x:distanceCap*Math.cos(an-angularWidthCap ) ,y:distanceCap*Math.sin(an-angularWidthCap ) ,z:i*64  },
			{ x:distanceCap*Math.cos(an+angularWidthCap ) ,y:distanceCap*Math.sin(an+angularWidthCap ) ,z:i*64  },
			{ x:distanceCap*Math.cos(an+angularWidthCap ) ,y:distanceCap*Math.sin(an+angularWidthCap ) ,z:i*64+60  },
			{ x:distanceCap*Math.cos(an-angularWidthCap ) ,y:distanceCap*Math.sin(an-angularWidthCap ) ,z:i*64+60  },
			{ x:distanceBase*Math.cos(an-angularWidthBase),y:distanceBase*Math.sin(an-angularWidthBase),z:i*64  },
			{ x:distanceBase*Math.cos(an+angularWidthBase),y:distanceBase*Math.sin(an+angularWidthBase),z:i*64  },

			{ x:distanceCap*Math.cos(an-angularWidthCap ) ,y:distanceCap*Math.sin(an-angularWidthCap ) ,z:4096+i*64  },
			{ x:distanceCap*Math.cos(an+angularWidthCap ) ,y:distanceCap*Math.sin(an+angularWidthCap ) ,z:4096+i*64  },
			{ x:distanceCap*Math.cos(an+angularWidthCap ) ,y:distanceCap*Math.sin(an+angularWidthCap ) ,z:4096+i*64+60  },
			{ x:distanceCap*Math.cos(an-angularWidthCap ) ,y:distanceCap*Math.sin(an-angularWidthCap ) ,z:4096+i*64+60  },
			{ x:distanceBase*Math.cos(an-angularWidthBase),y:distanceBase*Math.sin(an-angularWidthBase),z:4096+i*64  },
			{ x:distanceBase*Math.cos(an+angularWidthBase),y:distanceBase*Math.sin(an+angularWidthBase),z:4096+i*64  }
		)

		col = Math.floor(Math.random()*3)*2

		melodyTunnel_model.faces.push
		(
			{ color:col,   a:i*12  , b:i*12+3, c:i*12+2, d:i*12+1 },
			{ color:col+1, a:i*12+0, b:i*12+1, c:i*12+5, d:i*12+4 },

			{ color:col,   a:i*12+6, b:i*12+9, c:i*12+8, d:i*12+7 },
			{ color:col+1, a:i*12+6, b:i*12+7, c:i*12+11, d:i*12+10 }

		)


	}

	progressBarIndex++;
}


function melodyTunnel_render( currentTime, percentage, extraArguments )
{
	while( percentage>1 )
		percentage-=1

	//	background
//	offScreenCanvasContext.drawImage( backgrounds_red[ 4+(Math.floor(percentage*8)&3)], 0,0 )
	offScreenCanvasContext.clearRect( 0,0,320,160 )


	var	camera		= {x:16*Math.cos(percentage*Math.PI*2)*0,y:0*16*Math.cos(percentage*Math.PI*1.3),z:-168+4*1024*percentage},
		angles		= {x:0,y:0,z:percentage*Math.PI},
		fovAngle	= Math.PI/6


	//	fountain
	melodyTunnel_model.rotateAndProject(
		angles,
		camera,
		160, 80, fovAngle
	)

	melodyTunnel_model.sortFaces();
	melodyTunnel_model.drawTriangles( offScreenCanvasContext );


}

